import { Router } from 'express';
import { referralsController } from './controller';
import { authenticateUser, requireAdmin } from '@/middlewares/auth';

const router = Router();

// Attach user to req for downstream use
async function attachUser(req: any, res: any, next: any) {
  if (req.user) req.user = req.user;
  next();
}

// Attach admin to req for downstream use (simulate admin extraction)
async function attachAdmin(req: any, res: any, next: any) {
  req.admin = req.user; // Assume admin is authenticated user for now
  next();
}

// Register referral
router.post('/', authenticateUser, attachUser, referralsController.register);
// List my referrals
router.get('/', authenticateUser, attachUser, referralsController.list);
// Referral summary
router.get('/summary', authenticateUser, attachUser, referralsController.summary);
// Admin review
router.patch('/admin/:id', authenticateUser, requireAdmin, attachAdmin, referralsController.adminReview);

export default router; 